<?php
	include_once dirname(__FILE__).'/gift.class.php';

	$giftobj=new gift();

	function gift_typename($typeid=0)
	{
		global $giftobj;
		return $giftobj->typename(intval($typeid));
	}

	function formatgifturl($id,$is_rewrite=1,$preview=0)
	{
		global $giftobj;
		return $giftobj->formatgifturl($id,$is_rewrite,$preview);
	}

	function gift_name($id=0)
	{
		global $giftobj;
		$r= $giftobj->getgift(intval($id));
		return $r?$r['title']:'-';
	}

	function giftorderstatis($gid)
	{
		global $giftobj;
		return $giftobj->giftorderstatis(intval($gid));
	}

	function giftstatis($moduleid=30,$status=-1,$typeid=0)
	{
		global $giftobj;
		return $giftobj->giftstatis($moduleid,$status,$typeid);
	}

	function parse_gift_template($str)
	{
		$str=preg_replace('/\{niubi:gift\s+([^\}]+)\}/ie',"la_call_user_func('get_gift_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:gift\}/i',"<?php }unset(\$_DATA); ?>",$str);

		$str=preg_replace('/\{niubi:giftorder\s+([^\}]+)\}/ie',"la_call_user_func('get_giftorder_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:giftorder\}/i',"<?php }unset(\$_DATA); ?>",$str);

		$str=preg_replace('/\{niubi:gifttype\s+([^\}]+)\}/ie',"la_call_user_func('get_gifttype_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:gifttype\}/i',"<?php }unset(\$_DATA); ?>",$str); 

		return $str;
	}

	function get_giftorder_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('giftid'=>'0',
					'limit'=>'0',
					'row'=>'16');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_giftorder_data('.$giftid.','.$limit.','.$row.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_giftorder_data($giftid,$limit,$row)
	{
		global $cacheobj,$db,$siteidobj,$bbsobj;
	
		$result=$_DATA=array();
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;
		$giftid=intval($giftid)?intval($giftid):0;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).')';
		}
		else
		{
			$where='1';
		}

		
		$where.=$giftid?' AND giftid='.intval($giftid):'';
		
		$sql="SELECT * FROM `".LA_PRE."gift_order` WHERE $where ORDER BY `".LA_PRE."gift_order`.`exchangedate` DESC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}

	function get_gifttype_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('parentid'=>'0',
					'limit'=>'0',
					'row'=>'16');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_gifttype_data('.$parentid.','.$limit.','.$row.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_gifttype_data($parentid,$limit,$row)
	{
		global $cacheobj,$db,$siteidobj,$bbsobj;
	
		$result=$_DATA=array();
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;
		$parentid=intval($parentid)?intval($parentid):0;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).')';
		}
		else
		{
			$where='1';
		}

		
		$where.=$parentid?' AND parentid='.intval($parentid):'';
		
		$sql="SELECT * FROM `".LA_PRE."gift_type` WHERE $where ORDER BY `".LA_PRE."gift_type`.`id` ASC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}

	function get_gift_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('typeid'=>'0',
					'limit'=>'0',
					'row'=>'16',
					'istop'=>'-1',
					'userid'=>'0',
					'withthumb'=>'0');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_gift_data('.$typeid.','.$limit.','.$row.','.$istop.','.$userid.','.$withthumb.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_gift_data($typeid,$limit,$row,$istop,$userid,$withthumb)
	{
		global $cacheobj,$db,$siteidobj,$bbsobj;
	
		$result=$_DATA=array();
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;
		$userid=intval($userid)?intval($userid):0;
		$istop=intval($istop)>-1?intval($istop):-1;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).')';
		}
		else
		{
			$where='1';
		}

		if($istop==-1)
		{
			$where.='';
		}
		else if($istop==0)
		{
			$where.=' AND (istop='.intval($istop).' OR istop<'.TIME.')';
		}
		else
		{
			$where.=' AND istop>='.TIME;
		}

		$where.=$typeid?' AND typeid ='.intval($typeid):'';

		$where.=$withthumb?' AND thumb!=\'\'':'';
		
		$sql="SELECT * FROM `".LA_PRE."gift` WHERE $where ORDER BY `".LA_PRE."gift`.`updatetime` DESC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}
?>